/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.values;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import com.tristankechlo.livingthings.LivingThings;
import com.tristankechlo.livingthings.config.util.IConfig;
import java.util.ArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public final class IngredientValue
implements IConfig.Value<Ingredient> {
    private final String identifier;
    private final Ingredient defaultValue;
    private Ingredient value;

    public IngredientValue(String identifier, Item ... items) {
        this(identifier, Ingredient.m_43929_((ItemLike[])items));
    }

    public IngredientValue(String identifier, Ingredient defaultValue) {
        this.identifier = identifier;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    @Override
    public void setToDefault() {
        this.value = this.defaultValue;
    }

    @Override
    public JsonElement serialize(JsonObject json) {
        JsonElement element = this.get().m_43942_();
        json.add(this.getIdentifier(), element);
        return json;
    }

    @Override
    public void deserialize(JsonObject json) {
        if (json.has(this.getIdentifier())) {
            try {
                JsonElement element = json.get(this.getIdentifier());
                this.value = this.deserialize(element);
            }
            catch (Exception e) {
                LivingThings.LOGGER.warn("Failed to parse value '{}' as Ingredient, using default value.", (Object)this.getIdentifier());
                this.setToDefault();
            }
        } else {
            LivingThings.LOGGER.warn("No value '{}' was found, using default value.", (Object)this.getIdentifier());
            this.setToDefault();
        }
    }

    @Override
    public Ingredient get() {
        return this.value;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    private Ingredient deserialize(JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            throw new JsonSyntaxException("Ingredient '" + this.getIdentifier() + "' cannot be null");
        }
        if (jsonElement.isJsonObject()) {
            return IngredientValue.deserializeSingle(GsonHelper.m_13918_((JsonElement)jsonElement, (String)this.getIdentifier()));
        }
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            if (jsonArray.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            ArrayList list = new ArrayList();
            jsonArray.forEach(element -> {
                JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)"item");
                if (!json.has("item")) {
                    LivingThings.LOGGER.warn("Element '{}' is missing 'item' key, skipping...", (Object)json);
                    return;
                }
                Item item = ShapedRecipe.m_151278_((JsonObject)json);
                list.add(item);
            });
            return Ingredient.m_43929_((ItemLike[])((ItemLike[])list.toArray(new Item[0])));
        }
        throw new JsonSyntaxException("Expected item to be object or array of objects");
    }

    private static Ingredient deserializeSingle(JsonObject jsonObject) {
        Either<Item, TagKey<Item>> either = IngredientValue.deserializeO(jsonObject);
        if (either.left().isPresent()) {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)either.left().get()});
        }
        return Ingredient.m_204132_((TagKey)((TagKey)either.right().get()));
    }

    private static Either<Item, TagKey<Item>> deserializeO(JsonObject json) {
        if (json.has("item") && json.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (json.has("item")) {
            return Either.left((Object)ShapedRecipe.m_151278_((JsonObject)json));
        }
        if (json.has("tag")) {
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)resourceLocation);
            return Either.right((Object)tagKey);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }
}

